<?php $__env->startSection('title', __('expense.import_expense')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('expense.import_expense'); ?>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    
    <?php if(session('notification') || !empty($notification)): ?>
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <?php if(!empty($notification['msg'])): ?>
                        <?php echo e($notification['msg'], false); ?>

                    <?php elseif(session('notification.msg')): ?>
                        <?php echo e(session('notification.msg'), false); ?>

                    <?php endif; ?>
                </div>
            </div>  
        </div>     
    <?php endif; ?>
    
    <div class="row">
        <div class="col-sm-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
                <?php echo Form::open(['url' => action([\App\Http\Controllers\ExpenseController::class, 'storeExpenseImport']), 'method' => 'post', 'enctype' => 'multipart/form-data' ]); ?>

                    <div class="row">
                        <div class="col-sm-6">
                        <div class="col-sm-8">
                            <div class="form-group">
                                <?php echo Form::label('name', __( 'product.file_to_import' ) . ':'); ?>

                                <?php echo Form::file('expense_csv', ['accept'=> '.xls, .xlsx, .csv', 'required' => 'required']); ?>

                              </div>
                        </div>
                        <div class="col-sm-4">
                        <br>
                            <button type="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white"><?php echo app('translator')->get('messages.submit'); ?></button>
                        </div>
                        </div>
                    </div>
                <?php echo Form::close(); ?>

                <br><br>
                <div class="row">
                    <div class="col-sm-4">
                        <a href="<?php echo e(asset('files/import_expense_csv_template.csv'), false); ?>" class="tw-dw-btn tw-dw-btn-success tw-text-white" download><i class="fa fa-download"></i> <?php echo app('translator')->get('lang_v1.download_template_file'); ?></a>
                    </div>
                </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-sm-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __('lang_v1.instructions')]); ?>
                
                <table class="table table-striped">
                    <tr>
                        <th><?php echo app('translator')->get('lang_v1.col_no'); ?></th>
                        <th><?php echo app('translator')->get('lang_v1.col_name'); ?></th>
                        <th><?php echo app('translator')->get('lang_v1.instruction'); ?></th>
                    </tr>
                   
                    <tr>
                        <td>1</td>
                        <td><?php echo app('translator')->get('purchase.business_location'); ?></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td><?php echo app('translator')->get('expense.expense_category'); ?> <small class="text-muted">(<?php echo app('translator')->get('lang_v1.optional'); ?>)</small></td>
                        <td><?php echo app('translator')->get('lang_v1.category_ins'); ?> <br><small class="text-muted">(<?php echo app('translator')->get('lang_v1.category_ins2'); ?>)</small></td>
                    </tr>
                    <tr>
                        <td>3</td>
                        <td><?php echo app('translator')->get('product.sub_category'); ?> <small class="text-muted">(<?php echo app('translator')->get('lang_v1.optional'); ?>)</small></td>
                        <td><?php echo app('translator')->get('lang_v1.sub_category_ins'); ?> <br><small class="text-muted">(<?php echo app('translator')->get('lang_v1.sub_category_ins2'); ?>)</small></td>
                    </tr>

                    <tr>
                        <td>4</td>
                        <td><?php echo app('translator')->get('purchase.ref_no'); ?> <small class="text-muted">(<?php echo app('translator')->get('lang_v1.optional'); ?>)</small></td>
                        <td><?php echo app('translator')->get('lang_v1.leave_empty_to_autogenerate'); ?></td>
                    </tr>

                    <tr>
                        <td>5</td>
                        <td><?php echo app('translator')->get('messages.date'); ?> <small class="text-muted">(<?php echo app('translator')->get('lang_v1.optional'); ?>)</small></td>
                        <td><?php echo app('translator')->get('expense.date_format_instruction'); ?></td>
                    </tr>

                    <tr>
                        <td>6</td>
                        <td><?php echo app('translator')->get('expense.expense_for'); ?> <small class="text-muted">(<?php echo app('translator')->get('lang_v1.optional'); ?>)</small></td>
                        <td><?php echo app('translator')->get('expense.expense_for_help'); ?></td>
                    </tr>

                    <tr>
                        <td>7</td>
                        <td><?php echo app('translator')->get('lang_v1.contact_id'); ?> <small class="text-muted">(<?php echo app('translator')->get('lang_v1.optional'); ?>)</small></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>8</td>
                        <td><?php echo app('translator')->get('purchase.attach_document'); ?> <small class="text-muted">(<?php echo app('translator')->get('lang_v1.optional'); ?>)</small></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>9</td>
                        <td><?php echo app('translator')->get('product.applicable_tax'); ?> <small class="text-muted">(<?php echo app('translator')->get('lang_v1.optional'); ?>)</small></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>10</td>
                        <td><?php echo app('translator')->get('expense.expense_note'); ?> <small class="text-muted">(<?php echo app('translator')->get('lang_v1.optional'); ?>)</small></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>11</td>
                        <td><?php echo app('translator')->get('sale.total_amount'); ?></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>12</td>
                        <td><?php echo app('translator')->get('lang_v1.paid_amount'); ?></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>13</td>
                        <td><?php echo app('translator')->get('lang_v1.paid_on'); ?> </td>
                        <td><?php echo app('translator')->get('expense.date_format_instruction'); ?></td>
                    </tr>
                    
                    <tr>
                        <td>14</td>
                        <td><?php echo app('translator')->get('lang_v1.payment_method'); ?> </td>
                        <td><?php echo e(implode(", ", $payment_types), false); ?></td>
                    </tr>
                    <tr>
                        <td>15</td>
                        <td><?php echo app('translator')->get('lang_v1.payment_account'); ?> <small class="text-muted">(<?php echo app('translator')->get('lang_v1.optional'); ?>)</small></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>16</td>
                        <td><?php echo app('translator')->get('sale.payment_note'); ?> <small class="text-muted">(<?php echo app('translator')->get('lang_v1.optional'); ?>)</small></td>
                        <td></td>
                    </tr>

                </table>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smarthm1/smartpos.melianplus.co.tz/resources/views/expense/import.blade.php ENDPATH**/ ?>